<?php
if (!defined('ROVO_APP')) {
    die('Direct access not permitted');
}

$current_user = $auth->getCurrentUser();
if (!$current_user || $auth->isAdmin()) {
    header('Location: ../login.php');
    exit;
}

$current_page = basename($_SERVER['PHP_SELF'], '.php');

// Get unread notifications count
$unread_count = $db->fetchOne("SELECT COUNT(*) as count FROM notifications WHERE user_id = ? AND is_read = 0", [$current_user['id']])['count'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title ?? 'Dashboard'; ?> - RoVo Nigeria</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" rel="stylesheet">
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- SweetAlert2 -->
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700&family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
    
    <link rel="icon" type="image/png" sizes="32x32" href="../favicon/favicon-32x32.png">
    
    <style>
        :root {
            --primary: #D4A017;
            --secondary: #B8974A;
            --sidebar-width: 280px;
            --header-height: 70px;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: #f5f7fa;
            overflow-x: hidden;
        }
        
        /* Sidebar */
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            width: var(--sidebar-width);
            height: 100vh;
            background: linear-gradient(180deg, #1a1a1a 0%, #0d0d0d 100%);
            padding: 20px 0;
            overflow-y: auto;
            transition: transform 0.3s ease;
            z-index: 1000;
        }
        
        .sidebar.active {
            transform: translateX(0);
        }
        
        .sidebar-brand {
            padding: 0 20px 30px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            text-align: center;
        }
        
        .sidebar-brand h3 {
            color: var(--primary);
            font-family: 'Playfair Display', serif;
            font-size: 2rem;
            margin: 0;
        }
        
        .sidebar-brand p {
            color: #999;
            font-size: 0.85rem;
            margin: 5px 0 0;
        }
        
        .user-profile {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .user-avatar {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: var(--primary);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 1.5rem;
            margin: 0 auto 10px;
        }
        
        .user-name {
            color: white;
            font-weight: 600;
            margin-bottom: 5px;
        }
        
        .user-email {
            color: #999;
            font-size: 0.85rem;
        }
        
        .sidebar-menu {
            padding: 20px 0;
        }
        
        .sidebar-menu a {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: #ccc;
            text-decoration: none;
            transition: all 0.3s;
            border-left: 3px solid transparent;
        }
        
        .sidebar-menu a:hover {
            background: rgba(212, 160, 23, 0.1);
            color: var(--primary);
            border-left-color: var(--primary);
        }
        
        .sidebar-menu a.active {
            background: rgba(212, 160, 23, 0.15);
            color: var(--primary);
            border-left-color: var(--primary);
            font-weight: 600;
        }
        
        .sidebar-menu a i {
            width: 24px;
            margin-right: 12px;
            font-size: 1.1rem;
        }
        
        .sidebar-menu .badge {
            margin-left: auto;
        }
        
        /* Header */
        .main-header {
            position: fixed;
            top: 0;
            left: var(--sidebar-width);
            right: 0;
            height: var(--header-height);
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 30px;
            z-index: 999;
            transition: left 0.3s ease;
        }
        
        .menu-toggle {
            display: none;
            background: none;
            border: none;
            font-size: 1.5rem;
            color: #333;
            cursor: pointer;
        }
        
        .header-left h2 {
            margin: 0;
            font-size: 1.3rem;
            color: #333;
        }
        
        .header-right {
            display: flex;
            align-items: center;
            gap: 20px;
        }
        
        .notification-icon {
            position: relative;
            font-size: 1.3rem;
            color: #666;
            cursor: pointer;
            transition: color 0.3s;
        }
        
        .notification-icon:hover {
            color: var(--primary);
        }
        
        .notification-badge {
            position: absolute;
            top: -8px;
            right: -8px;
            background: #dc3545;
            color: white;
            border-radius: 50%;
            width: 18px;
            height: 18px;
            font-size: 0.7rem;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            margin-top: var(--header-height);
            padding: 30px;
            min-height: calc(100vh - var(--header-height));
            transition: margin-left 0.3s ease;
        }
        
        /* Cards */
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            margin-bottom: 30px;
            transition: transform 0.3s, box-shadow 0.3s;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.12);
        }
        
        /* Sidebar Overlay */
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.5);
            z-index: 999;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .sidebar-overlay.active {
            opacity: 1;
        }
        
        /* Mobile Styles */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }
            
            .sidebar.active {
                transform: translateX(0);
            }
            
            .main-header {
                left: 0;
            }
            
            .main-content {
                margin-left: 0;
            }
            
            .menu-toggle {
                display: block;
            }
            
            .sidebar-overlay {
                display: block;
            }
            
            .header-left h2 {
                font-size: 1.1rem;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar Overlay (for mobile) -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>
    
    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar">
        <div class="sidebar-brand">
            <h3>RoVo</h3>
            <p>My Dashboard</p>
        </div>
        
        <div class="user-profile">
            <?php if ($current_user['profile_photo']): ?>
            <img src="../<?php echo htmlspecialchars($current_user['profile_photo']); ?>" 
                 alt="Profile" class="user-avatar" style="object-fit: cover;">
            <?php else: ?>
            <div class="user-avatar">
                <?php echo strtoupper(substr($current_user['first_name'], 0, 1) . substr($current_user['last_name'], 0, 1)); ?>
            </div>
            <?php endif; ?>
            
            <div class="user-name"><?php echo htmlspecialchars($current_user['first_name'] . ' ' . $current_user['last_name']); ?></div>
            <div class="user-email"><?php echo htmlspecialchars($current_user['email']); ?></div>
        </div>
        
        <nav class="sidebar-menu">
            <a href="dashboard.php" class="<?php echo $current_page === 'dashboard' ? 'active' : ''; ?>">
                <i class="fas fa-th-large"></i>
                <span>Dashboard</span>
            </a>
            
            <a href="applications.php" class="<?php echo $current_page === 'applications' ? 'active' : ''; ?>">
                <i class="fas fa-file-alt"></i>
                <span>My Applications</span>
                <?php
                $pending_apps = $db->fetchOne("SELECT COUNT(*) as count FROM rental_applications WHERE user_id = ? AND status = 'pending'", [$current_user['id']])['count'];
                if ($pending_apps > 0):
                ?>
                <span class="badge bg-warning"><?php echo $pending_apps; ?></span>
                <?php endif; ?>
            </a>
            
            <a href="properties.php" class="<?php echo $current_page === 'properties' ? 'active' : ''; ?>">
                <i class="fas fa-building"></i>
                <span>Browse Properties</span>
            </a>
            
            <a href="payments.php" class="<?php echo $current_page === 'payments' ? 'active' : ''; ?>">
                <i class="fas fa-credit-card"></i>
                <span>Payments</span>
            </a>
            
            <a href="documents.php" class="<?php echo $current_page === 'documents' ? 'active' : ''; ?>">
                <i class="fas fa-folder"></i>
                <span>My Documents</span>
            </a>
            
            <a href="calculator.php" class="<?php echo $current_page === 'calculator' ? 'active' : ''; ?>">
                <i class="fas fa-calculator"></i>
                <span>Rent Calculator</span>
            </a>
            
            <a href="messages.php" class="<?php echo $current_page === 'messages' ? 'active' : ''; ?>">
                <i class="fas fa-envelope"></i>
                <span>Messages</span>
            </a>
            
            <a href="profile.php" class="<?php echo $current_page === 'profile' ? 'active' : ''; ?>">
                <i class="fas fa-user"></i>
                <span>My Profile</span>
            </a>
            
            <a href="notifications.php" class="<?php echo $current_page === 'notifications' ? 'active' : ''; ?>">
                <i class="fas fa-bell"></i>
                <span>Notifications</span>
                <?php if ($unread_count > 0): ?>
                <span class="badge bg-danger"><?php echo $unread_count; ?></span>
                <?php endif; ?>
            </a>
            
            <a href="../logout.php" onclick="return confirm('Are you sure you want to logout?')">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </nav>
    </aside>
    
    <!-- Main Header -->
    <header class="main-header">
        <div class="header-left">
            <button class="menu-toggle" id="menuToggle">
                <i class="fas fa-bars"></i>
            </button>
            <h2><?php echo $page_title ?? 'Dashboard'; ?></h2>
        </div>
        
        <div class="header-right">
            <a href="notifications.php" class="notification-icon">
                <i class="far fa-bell"></i>
                <?php if ($unread_count > 0): ?>
                <span class="notification-badge"><?php echo $unread_count; ?></span>
                <?php endif; ?>
            </a>
            
            <div class="dropdown">
                <button class="btn btn-link text-decoration-none" data-bs-toggle="dropdown">
                    <i class="fas fa-user-circle" style="font-size: 1.8rem; color: var(--primary);"></i>
                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="profile.php"><i class="fas fa-user me-2"></i> Profile</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item" href="../logout.php"><i class="fas fa-sign-out-alt me-2"></i> Logout</a></li>
                </ul>
            </div>
        </div>
    </header>
    
    <!-- Main Content -->
    <main class="main-content">

<script>
// Mobile menu toggle
document.addEventListener('DOMContentLoaded', function() {
    const menuToggle = document.getElementById('menuToggle');
    const sidebar = document.getElementById('sidebar');
    const sidebarOverlay = document.getElementById('sidebarOverlay');
    
    menuToggle.addEventListener('click', function() {
        sidebar.classList.toggle('active');
        sidebarOverlay.classList.toggle('active');
    });
    
    sidebarOverlay.addEventListener('click', function() {
        sidebar.classList.remove('active');
        sidebarOverlay.classList.remove('active');
    });
    
    // Close sidebar when clicking a link on mobile
    if (window.innerWidth <= 768) {
        const sidebarLinks = sidebar.querySelectorAll('a');
        sidebarLinks.forEach(link => {
            link.addEventListener('click', function() {
                sidebar.classList.remove('active');
                sidebarOverlay.classList.remove('active');
            });
        });
    }
});
</script>