//  Typing Animation 
  
        document.addEventListener("DOMContentLoaded", function () {
            const textElement = document.getElementById("typing-text");
            const texts = [
                "We help you buy, sell, and invest in real estate with ease and trust!",
                "Secure the best deals in the real estate market today!",
                "Find your dream home or sell your property effortlessly!",
                "Trusted experts in real estate investments and transactions."
            ];
            let textIndex = 0;
            let charIndex = 0;
            let isDeleting = false;
    
            function typeEffect() {
                let currentText = texts[textIndex];
                if (isDeleting) {
                    textElement.innerHTML = currentText.substring(0, charIndex--);
                } else {
                    textElement.innerHTML = currentText.substring(0, charIndex++);
                }
    
                if (!isDeleting && charIndex === currentText.length) {
                    isDeleting = true;
                    setTimeout(typeEffect, 1500); // Pause before deleting
                } else if (isDeleting && charIndex === 0) {
                    isDeleting = false;
                    textIndex = (textIndex + 1) % texts.length;
                    setTimeout(typeEffect, 300); // Pause before typing next text
                } else {
                    setTimeout(typeEffect, isDeleting ? 50 : 100);
                }
            }
    
            typeEffect();
        });
 {
    /* End */}


    
// form

 const sellCheckbox = document.getElementById("statusSell");
const rentCheckbox = document.getElementById("statusRent");
const surveyField = document.getElementById("surveyDocumentField");
const photoField = document.getElementById("propertyPhotoField");
const surveyInput = document.getElementById("surveyDocument");
const photoInput = document.getElementById("propertyPhoto");

function updateFields() {
    const isSellChecked = sellCheckbox.checked;
    const isRentChecked = rentCheckbox.checked;

    if (isSellChecked) {
        surveyField.style.display = "block";
        photoField.style.display = "block";
        surveyInput.required = true;
        photoInput.required = true;
    } else {
        surveyField.style.display = "none";
        photoField.style.display = "none";
        surveyInput.required = false;
        photoInput.required = false;
    }
}

sellCheckbox.addEventListener("change", updateFields);
rentCheckbox.addEventListener("change", updateFields);

document.getElementById("sellForm").addEventListener("submit", function(event) {
    event.preventDefault();

    // Check if at least one status is selected
    if (!sellCheckbox.checked && !rentCheckbox.checked) {
        document.getElementById("statusError").style.display = "block";
        showMessage("Please select at least one property status.", "error");
        return;
    } else {
        document.getElementById("statusError").style.display = "none";
    }

    // Check if terms are agreed
    if (!document.getElementById("agreeTerms").checked) {
        showMessage("You must agree to the Terms and Conditions.", "error");
        return;
    }

    // Simulate successful submission
    showMessage("Thank you! A real estate agent will contact you within 48 hours.", "success");

    // Hide the form after submission
    setTimeout(() => {
        document.getElementById("sellForm").reset(); // Clear form fields
        document.getElementById("sellForm").style.display = "block"; // Show form again
        updateFields(); // Reset field visibility after form reset
    }, 5000);
});

// Function to show a message dynamically
function showMessage(message, type) {
    let messageBox = document.createElement("div");
    messageBox.className = `alert-message ${type}`;
    messageBox.textContent = message;

    let formContainer = document.getElementById("sellForm").parentNode;
    formContainer.appendChild(messageBox);

    setTimeout(() => {
        messageBox.remove();
    }, 5000);
}
// end

//  vidio owl carousel
$(document).ready(function () {
    var owl = $(".owl-carousel");
    var isNext = true; // Track direction (true = Next, false = Prev)
    var autoplayDelay = 60000; // 1 minute (60,000ms)

    owl.owlCarousel({
        loop: true, // Enable infinite loop
        margin: 10,
        nav: false, // Hide default navigation
        dots: true,
        autoplay: false, // Disable default autoplay
        items: 1,
    });

    // Add custom navigation button
    $(".video-container").append('<button id="customNav" class="carousel-btn next-mode">&gt;</button>');

    $("#customNav").click(function () {
        if (isNext) {
            owl.trigger("next.owl.carousel");
        } else {
            owl.trigger("prev.owl.carousel");
        }
    });

    // Handle slide changes and button updates
    owl.on("changed.owl.carousel", function (event) {
        var totalItems = event.item.count;
        var currentIndex = event.item.index % totalItems + 1; // Fix index calculation

        if (!isNext && currentIndex === 1) {
            $("#customNav").html("&gt;"); // Change back to ">"
            $("#customNav").addClass("next-mode").removeClass("prev-mode");
            isNext = true;
        } else if (isNext && currentIndex === totalItems) {
            $("#customNav").html("&lt;"); // Change to "<"
            $("#customNav").addClass("prev-mode").removeClass("next-mode");
            isNext = false;
        }

        // Play video for 1 minute before changing slide
        var currentVideo = $(".owl-item.active video")[0];
        if (currentVideo) {
            currentVideo.play();
            setTimeout(function () {
                owl.trigger("next.owl.carousel");
            }, autoplayDelay);
        }
    });

    // Auto-play video on slide change
    $(".owl-carousel video").on("play", function () {
        var videoElement = this;
        setTimeout(function () {
            if (!videoElement.paused) {
                owl.trigger("next.owl.carousel");
            }
        }, autoplayDelay);
    });
});

