<?php
// ==========================================
// FILE: admin/ajax/get-user-details.php
// ==========================================
define('ROVO_APP', true);
require_once '../../config.php';
require_once '../../Auth.php';

if (!$auth->isAdmin()) {
    die('Unauthorized');
}

$user_id = (int)($_GET['id'] ?? 0);

$sql = "SELECT u.*, 
        COUNT(DISTINCT ra.id) as total_applications,
        COUNT(DISTINCT p.id) as total_payments,
        SUM(p.amount) as total_spent
        FROM users u
        LEFT JOIN rental_applications ra ON u.id = ra.user_id
        LEFT JOIN payments p ON u.id = p.user_id AND p.status = 'completed'
        WHERE u.id = ?
        GROUP BY u.id";

$user = $db->fetchOne($sql, [$user_id]);

if (!$user) {
    die('User not found');
}

// Get recent activities
$activities = $db->fetchAll("SELECT * FROM activity_logs WHERE user_id = ? ORDER BY created_at DESC LIMIT 10", [$user_id]);
?>

<div class="row">
    <div class="col-md-4 text-center mb-3">
        <div class="user-avatar mx-auto" style="width: 100px; height: 100px; font-size: 2rem;">
            <?php echo strtoupper(substr($user['first_name'], 0, 1) . substr($user['last_name'], 0, 1)); ?>
        </div>
        <h5 class="mt-3"><?php echo htmlspecialchars($user['first_name'] . ' ' . $user['last_name']); ?></h5>
        <span class="badge bg-<?php echo $user['status'] === 'active' ? 'success' : 'warning'; ?>">
            <?php echo ucfirst($user['status']); ?>
        </span>
    </div>
    
    <div class="col-md-8">
        <h6>Contact Information</h6>
        <table class="table table-sm">
            <tr>
                <td><strong>Email:</strong></td>
                <td><?php echo htmlspecialchars($user['email']); ?></td>
            </tr>
            <tr>
                <td><strong>Phone:</strong></td>
                <td><?php echo htmlspecialchars($user['phone']); ?></td>
            </tr>
            <tr>
                <td><strong>Address:</strong></td>
                <td><?php echo htmlspecialchars($user['address'] ?? 'N/A'); ?></td>
            </tr>
        </table>
        
        <h6>Statistics</h6>
        <table class="table table-sm">
            <tr>
                <td><strong>Applications:</strong></td>
                <td><?php echo $user['total_applications']; ?></td>
            </tr>
            <tr>
                <td><strong>Payments:</strong></td>
                <td><?php echo $user['total_payments']; ?></td>
            </tr>
            <tr>
                <td><strong>Total Spent:</strong></td>
                <td>₦<?php echo number_format($user['total_spent']); ?></td>
            </tr>
            <tr>
                <td><strong>Registered:</strong></td>
                <td><?php echo date('M d, Y', strtotime($user['created_at'])); ?></td>
            </tr>
            <tr>
                <td><strong>Last Login:</strong></td>
                <td><?php echo $user['last_login'] ? date('M d, Y H:i', strtotime($user['last_login'])) : 'Never'; ?></td>
            </tr>
        </table>
    </div>
</div>

<?php if (!empty($activities)): ?>
<hr>
<h6>Recent Activities</h6>
<div style="max-height: 200px; overflow-y: auto;">
    <?php foreach ($activities as $activity): ?>
    <div class="d-flex align-items-start mb-2 pb-2 border-bottom">
        <i class="fas fa-circle text-primary me-2" style="font-size: 0.5rem; margin-top: 8px;"></i>
        <div>
            <small><?php echo htmlspecialchars($activity['description']); ?></small>
            <br>
            <small class="text-muted"><?php echo date('M d, Y H:i', strtotime($activity['created_at'])); ?></small>
        </div>
    </div>
    <?php endforeach; ?>
</div>
<?php endif; ?>






