<?php
define('ROVO_APP', true);
require_once '../../config.php';
require_once '../../Auth.php';

if (!$auth->isAdmin()) die('Unauthorized');

$app_id = (int)($_GET['id'] ?? 0);

$sql = "SELECT * FROM sell_applications WHERE id = ?";
$app = $db->fetchOne($sql, [$app_id]);

if (!$app) die('Application not found');

$property_status = json_decode($app['property_status'], true);
?>

<div class="row">
    <div class="col-md-6">
        <h6>Seller Information</h6>
        <table class="table table-sm table-bordered">
            <tr>
                <td><strong>Application #:</strong></td>
                <td><?php echo htmlspecialchars($app['application_number']); ?></td>
            </tr>
            <tr>
                <td><strong>Name:</strong></td>
                <td><?php echo htmlspecialchars($app['seller_name']); ?></td>
            </tr>
            <tr>
                <td><strong>Email:</strong></td>
                <td><?php echo htmlspecialchars($app['email']); ?></td>
            </tr>
            <tr>
                <td><strong>Phone:</strong></td>
                <td><?php echo htmlspecialchars($app['phone']); ?></td>
            </tr>
            <tr>
                <td><strong>Address:</strong></td>
                <td><?php echo htmlspecialchars($app['address'] ?? 'N/A'); ?></td>
            </tr>
        </table>
    </div>
    
    <div class="col-md-6">
        <h6>Property Information</h6>
        <table class="table table-sm table-bordered">
            <tr>
                <td><strong>Type:</strong></td>
                <td><?php echo htmlspecialchars($app['property_type']); ?></td>
            </tr>
            <tr>
                <td><strong>Category:</strong></td>
                <td><?php echo htmlspecialchars($app['seller_category']); ?></td>
            </tr>
            <tr>
                <td><strong>Price:</strong></td>
                <td><strong>₦<?php echo number_format($app['price'], 2); ?></strong></td>
            </tr>
            <tr>
                <td><strong>Status:</strong></td>
                <td>
                    <?php
                    $badge_class = [
                        'pending' => 'warning',
                        'under_review' => 'info',
                        'approved' => 'success',
                        'listed' => 'primary',
                        'sold' => 'dark',
                        'rejected' => 'danger'
                    ][$app['status']] ?? 'secondary';
                    ?>
                    <span class="badge bg-<?php echo $badge_class; ?>">
                        <?php echo ucfirst(str_replace('_', ' ', $app['status'])); ?>
                    </span>
                </td>
            </tr>
        </table>
    </div>
</div>

<?php if (!empty($property_status)): ?>
<div class="row mt-3">
    <div class="col-12">
        <h6>Property Status</h6>
        <div class="alert alert-info">
            <?php foreach ($property_status as $key => $value): ?>
                <div><strong><?php echo ucfirst(str_replace('_', ' ', $key)); ?>:</strong> <?php echo htmlspecialchars($value); ?></div>
            <?php endforeach; ?>
        </div>
    </div>
</div>
<?php endif; ?>

<div class="row mt-3">
    <div class="col-md-6">
        <h6>Documents</h6>
        <?php if ($app['survey_document']): ?>
        <div class="mb-2">
            <a href="../../<?php echo htmlspecialchars($app['survey_document']); ?>" 
               target="_blank" class="btn btn-sm btn-outline-primary">
                <i class="fas fa-file-pdf"></i> Survey Document
            </a>
        </div>
        <?php endif; ?>
        
        <?php if ($app['property_photo']): ?>
        <div class="mb-2">
            <a href="../../<?php echo htmlspecialchars($app['property_photo']); ?>" 
               target="_blank" class="btn btn-sm btn-outline-primary">
                <i class="fas fa-image"></i> Property Photo
            </a>
        </div>
        <?php endif; ?>
        
        <?php if (!$app['survey_document'] && !$app['property_photo']): ?>
        <p class="text-muted">No documents uploaded</p>
        <?php endif; ?>
    </div>
    
    <div class="col-md-6">
        <h6>Application Details</h6>
        <table class="table table-sm table-bordered">
            <tr>
                <td><strong>Terms Accepted:</strong></td>
                <td>
                    <?php if ($app['terms_accepted']): ?>
                        <span class="badge bg-success">Yes</span>
                    <?php else: ?>
                        <span class="badge bg-danger">No</span>
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <td><strong>Submitted:</strong></td>
                <td><?php echo date('F d, Y H:i', strtotime($app['created_at'])); ?></td>
            </tr>
            <tr>
                <td><strong>Last Updated:</strong></td>
                <td><?php echo date('F d, Y H:i', strtotime($app['updated_at'])); ?></td>
            </tr>
        </table>
    </div>
</div>